﻿using log4net;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.Data;
using VA.PPMS.IWS.Api.Helpers;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;
using VA.PPMS.IWS.Common;

namespace VA.PPMS.IWS.Api.Controllers
{
    [Route("[controller]/v1")]
    public class CcnDataStreamController : Controller
    {
        private readonly ILog _logger;
        private readonly IIwsConfiguration _configuration;
        private readonly IHttpClientHandler _client;

        public CcnDataStreamController(ILog logger, IIwsConfiguration configuration, IHttpClientHandler client)
        {
            _logger = logger;
            _configuration = configuration;
            _client = client;
        }

        [HttpPost]
        public async Task<IActionResult> Post([FromBody]string payload)
        {
            var message = DasHelper.ParseHeaders(Request);

            try
            {
                _logger.Info("@@@@@ Info - Start POST for CcnDataStreamController @@@@@");

                _logger.Info($"Start POST data - CcnDataStreamController");

                using (var response = await _client.PostAsync(await _configuration.GetCcnDataStreamUri(), payload, message))
                {
                    _logger.Info($"End POST data - CcnDataStreamController");

                    if (response.IsSuccessStatusCode)
                    {
                        _logger.Info("@@@@@ Info - End POST for CcnDataStreamController @@@@@");

                        return StatusCode(StatusCodes.Status201Created);
                    }

                    _logger.Error($"Unable to process Providers. There was an error posting to the Function API: {response}");
                    var error = await response.Content.ReadAsStringAsync();
                    _logger.Error($"CcnDataStreamController POST Exception. The error is {error}: {response}");

                    return StatusCode((int)response.StatusCode, $"Unable to process Providers for transaction: {message.TransactionId}. {response.RequestMessage}");
                }
            }
            catch (Exception ex)
            {
                _logger.Error($"CcnDataStreamController POST Exception: {ex} ");
                return StatusCode(StatusCodes.Status500InternalServerError, ex.Message);
            }
        }
    }
}